/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UserSettingsBean;
import com.ibm.hwmca.fw.settings.user.ConfirmationSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.UserTaskManager;

public class ConfirmationSettingsBean
extends UserSettingsBean {
    private static final String TRACE_MASKT = "HUSTBC T";
    private static final String TRACE_MASKF = "HUSRBC F";
    private static final String TRACE_MASKD = "HUSRBC D";
    private static final String CONFIRM_ELEMENTS = "ConfirmSetInformationGB";
    private static final String DEFAULT_ELEMENT = "UseNoDefaultActionToggle";
    private static final String DISABLE = "NoShowConfirmationsChoice";
    private static final String ENABLE_WITH_LIST = "EnableWithObjectListChoice";
    private static final String ENABLE_WITHOUT_LIST = "EnableWithoutObjectListChoice";
    private static final String NO_DEFAULT = "UseNoDefaultActionToggle";
    private ConfirmationSettings settings;
    private ConfirmationSettings savedSettings;
    private String[] m_sConfirmSetInformationGBSelection;
    private boolean m_bUseNoDefaultActionToggle;

    public void setUserSettings(ConfirmationSettings settings) {
        Trace.trace(TRACE_MASKF, "-> ConfirmationSettingsBean.setUserSettings()");
        Trace.trace(TRACE_MASKF, settings);
        this.settings = settings;
        Trace.trace(TRACE_MASKF, "<- ConfirmationSettingsBean.setUserSettings()");
    }

    protected boolean hasSettingsChanged() {
        Trace.trace(TRACE_MASKF, "-> ConfirmationSettingsBean.hasSettingsChanged()");
        UserTaskManager utm = this.getUserTaskManager();
        utm.storeAllElements();
        boolean result = !this.settings.equals(this.savedSettings);
        Trace.trace(TRACE_MASKF, "<- ConfirmationSettingsBean.hasSettingsChanged(), result is " + result);
        return result;
    }

    protected void refreshPanel(UserTaskManager utm) {
        String prefix = this.getMountPrefix();
        utm.refreshElement(prefix + CONFIRM_ELEMENTS);
        utm.refreshElement(prefix + "UseNoDefaultActionToggle");
    }

    protected void updateUserSettings() {
        Trace.trace(TRACE_MASKF, "<> ConfirmationSettingsBean.updateUserSettings()");
        this.savedSettings = (ConfirmationSettings)this.settings.clone();
    }

    protected void resetUserSettings(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "<> ConfirmationSettingsBean.resetUserSettings()");
        this.settings = (ConfirmationSettings)this.savedSettings.clone();
        this.initConfirmData();
        this.refreshPanel(utm);
    }

    protected UserSettings getUserSettings() {
        Trace.trace(TRACE_MASKF, "<> ConfirmationSettingsBean.getUserSettings()");
        return this.settings;
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKF, "-> ConfirmationSettingBean.update()");
        this.setUserSettings((ConfirmationSettings)object);
        this.initConfirmData();
        this.refreshPanel(this.getUserTaskManager());
        Trace.trace(TRACE_MASKF, "<- ConfirmationsSettingBean.update()");
    }

    private void initConfirmData() {
        Trace.trace(TRACE_MASKF, "-> ConfirmationsSettingBean.initConfirmData()");
        Trace.trace(TRACE_MASKF, this.settings);
        this.m_sConfirmSetInformationGBSelection[0] = this.settings.showConfirmations() ? (this.settings.showWithObjectList() ? ENABLE_WITH_LIST : ENABLE_WITHOUT_LIST) : DISABLE;
        this.m_bUseNoDefaultActionToggle = this.settings.useNoAsDefault();
        Trace.trace(TRACE_MASKF, "<- ConfirmationsSettingBean.initConfirmData()");
    }

    public String[] getConfirmSetInformationGBSelection() {
        return this.m_sConfirmSetInformationGBSelection;
    }

    public void setConfirmSetInformationGBSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "-> ConfirmationSettingBean.setConfirmSetInformationGBSelection()");
        if (selected != null && selected.length > 0) {
            Trace.trace(TRACE_MASKF, "   selected[0] is " + selected[0]);
            this.m_sConfirmSetInformationGBSelection[0] = selected[0];
            if (this.m_sConfirmSetInformationGBSelection[0].endsWith(ENABLE_WITH_LIST)) {
                this.settings.setShowConfirmations(true);
                this.settings.setShowWithObjectList(true);
            } else if (this.m_sConfirmSetInformationGBSelection[0].endsWith(ENABLE_WITHOUT_LIST)) {
                this.settings.setShowConfirmations(true);
                this.settings.setShowWithObjectList(false);
            } else if (this.m_sConfirmSetInformationGBSelection[0].endsWith(DISABLE)) {
                this.settings.setShowConfirmations(false);
                this.settings.setShowWithObjectList(false);
            }
        }
        Trace.trace(TRACE_MASKF, this.settings);
        Trace.trace(TRACE_MASKF, "<- ConfirmationSettingBean.setConfirmSetInformationGBSelection()");
    }

    public boolean isUseNoDefaultActionToggle() {
        return this.m_bUseNoDefaultActionToggle;
    }

    public void setUseNoDefaultActionToggle(boolean b) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKF, "<> ConfirmationSettingBean.setUseNoDefaultActionToggle()");
        this.m_bUseNoDefaultActionToggle = b;
        this.settings.setUseNoAsDefault(this.m_bUseNoDefaultActionToggle);
    }

    public void prepare() {
        this.savedSettings = (ConfirmationSettings)this.settings.clone();
        this.m_sConfirmSetInformationGBSelection = new String[1];
        this.initConfirmData();
    }
}

